package App;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;

import org.cef.callback.CefCookieVisitor;
import org.cef.misc.BoolRef;
import org.cef.network.CefCookie;

public class MngCookies extends AbstractTableModel implements CefCookieVisitor, Runnable {
	private static final long serialVersionUID = 1L;
	private final String[] columnNames;
  private Vector<Object[]> rowData = new Vector<>();
  private static String userNameLoggedIn="";
  private static String cookieExpires="";
  
  @Override
	public void run() {
		
	}
  
  public MngCookies() {
    super();
    columnNames = new String[] {"Name", "Value", "Domain", "Path", "Secure", "HTTP only",
            "Created", "Last Access", "Expires"};
  }

  // add an entry to the table
  public boolean visit(CefCookie cookie, int count, int total, BoolRef delete) {
    Object[] entry = {cookie.name, cookie.value, cookie.domain, cookie.path,
            cookie.secure, cookie.httponly, cookie.creation,
            cookie.lastAccess, cookie.expires};
    int row = rowData.size();
    rowData.addElement(entry);
    fireTableRowsInserted(row, row);
    
    if (!getCookieNameLoggedIn(cookie).isEmpty()) {
    	getCookieUserNameLoggedIn(cookie);
    }
    
    return true;
  }
	
	public void getCookieUserNameLoggedIn(CefCookie cookie) {
		String[] rawCookieValue = cookie.value.split("%");
		if (cookie.name.contains("wordpress_logged_in")) {
			MngCookies.userNameLoggedIn = rawCookieValue[0];
			MngCookies.cookieExpires = (cookie.expires) != null ? cookie.expires.toString() : "";
		}
    }
	
	public static String getUserNameLoggedIn() {
		return MngCookies.userNameLoggedIn;
	}
	
	public static String getcookieExpires() {
		return MngCookies.cookieExpires;
	}
	
	public String getCookieNameLoggedIn(CefCookie cookie) {
		String cookieName = "";
		if (cookie.name.contains("wordpress_logged_in")) {
			cookieName = cookie.name;
		}
		return cookieName;
	}
	
	public String getAllCookiesNane(CefCookie cookie) {
		return cookie.name;
  }
	
	@Override
	public int getRowCount() {
		return rowData.size();
	}
	
	@Override
	public int getColumnCount() {
		return columnNames.length;
	}
	
	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		return rowData.get(rowIndex)[columnIndex];
	}
}
