package App;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;

import javax.imageio.ImageIO;
import Browser.MainFrame;
import Browser.ServerPolling;

public class TrayMenu {
	public static TrayIcon trayIcon;

	public static void main(String[] args) throws AWTException, IOException {
		if (SystemTray.isSupported() == false) {
			System.err.println("No system tray available");
			return;
		}
		// create a action listener to listen for default action executed on the tray icon
		ActionListener settingListener = new ActionListener() {
			@Override
			public void actionPerformed(java.awt.event.ActionEvent e) {
				try {
					MngSetting.main(args);
				} catch (URISyntaxException | InterruptedException | IOException e1) {
					e1.printStackTrace();
				}
			}
		};
		ActionListener videochatListener = new ActionListener() {
			@Override
			public void actionPerformed(java.awt.event.ActionEvent e) {
					try {
						ServerPolling.stopSSE();
						MainFrame.main(args);
					} catch (InterruptedException | IOException | URISyntaxException e1) {
						e1.printStackTrace();
					}
			}
		};
		ActionListener cancelListener = new ActionListener() {
			@Override
			public void actionPerformed(java.awt.event.ActionEvent e) {
				try {
					ServerPolling.cancelCall();
				} catch (InterruptedException | IOException | URISyntaxException e1) {
					e1.printStackTrace();
				}
			}
		};
		ActionListener closeListener = new ActionListener() {
			@Override
			public void actionPerformed(java.awt.event.ActionEvent e) {
				try {
					ServerPolling.stopSSE();
					ServerPolling.appExit();
				} catch (IOException | InterruptedException | URISyntaxException e1) {
					e1.printStackTrace();
				}
				System.exit(0);
			}
		};
		ActionListener trayIconListener = new ActionListener() {
			@Override
			public void actionPerformed(java.awt.event.ActionEvent e) {
				trayIcon.setToolTip(ServerPolling.trayMenuToolTip);
			}
		};
		// create a pop-up menu
		PopupMenu popup = new PopupMenu();

		MenuItem settingItem = new MenuItem("Setting");
		settingItem.addActionListener(settingListener);
		popup.add(settingItem);

		popup.addSeparator();

		MenuItem videochatItem = new MenuItem("Make a call");
		videochatItem.addActionListener(videochatListener);
		popup.add(videochatItem);

		MenuItem cancelItem = new MenuItem("Cancel call");
		cancelItem.addActionListener(cancelListener);
		popup.add(cancelItem);

		popup.addSeparator();

		MenuItem exitItem = new MenuItem("Exit");
		exitItem.addActionListener(closeListener);
		popup.add(exitItem);

		// construct a TrayIcon
		SystemTray tray = SystemTray.getSystemTray();
		
		BufferedImage imgIcon = null;
		
		if (null != TrayMenu.class.getResource("/src/img/logo.png")) {
			imgIcon = ImageIO.read( 
				TrayMenu.class.getResource("/src/img/logo.png")
			);
		} else {
			imgIcon = ImageIO.read( 
				TrayMenu.class.getResource("/img/logo.png")
			);
		}

		TrayIcon trayIcon = new TrayIcon(imgIcon, "Video chat", popup);
		trayIcon.setImageAutoSize(true);
		trayIcon.addActionListener(trayIconListener);

		tray.add(trayIcon);
		// start ServerPolling
		ServerPolling serverPolling = new ServerPolling();
		try {
			serverPolling.start();
		} catch (IOException | URISyntaxException | InterruptedException e1) {
			e1.printStackTrace();
		}
	}
}
