package Browser;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.sse.InboundSseEvent;
import javax.ws.rs.sse.SseEventSource;

import org.json.JSONException;
import org.json.JSONObject;

import App.MngCookies;
import App.MngSetting;

public class ServerPolling {
	public static String trayMenuToolTip = "Video chat";
	public static String UserName = "";
	public static String GuestName = "";
	
	public static Client clientSSE;
	public static SseEventSource clientEventSource;
	
	public static void main(String[] args) {
		System.out.println("ServerPolling ready");
	}
	
	public void start() throws IOException, URISyntaxException, InterruptedException {
		
		Thread t0 = new Thread(MngSetting.getCookieManager());
		t0.start();
		Thread.sleep(1000);
		
		Thread t1 = new Thread(new MngCookies());
		t1.start();
		Thread.sleep(1000);
		
		Thread t2 = new Thread(ServerPolling.UserName = MngCookies.getUserNameLoggedIn());
		t2.start();
        
		System.out.println("UserName: " + ServerPolling.UserName);
		t0.join();
		t1.join();
		t2.join();
		
		if (!ServerPolling.UserName.isEmpty()) {
			this.startSSE();
		}
  }
	
	public void startSSE() throws InterruptedException, IOException, URISyntaxException {
		String urlAjax = "https://" + MainFrame.getUrlAjax();
		String webrtc2_hostId = "?webrtc2_hostId=" + ServerPolling.UserName;
		String urlSite = urlAjax +  webrtc2_hostId + "&action=sse";
		
		Client client = ClientBuilder.newClient();
    WebTarget target = client.target(urlSite);

  	clientEventSource = SseEventSource.target(target).build();
    clientEventSource.register(this::onMessage, this::onError, this::onComplete);
    clientEventSource.open();

	}
	
	public static void stopSSE() throws InterruptedException {
		if (null != clientEventSource && clientEventSource.isOpen()) {
			clientEventSource.close();
		}
		if (null != clientSSE) {
			clientSSE.close();
		}
	}
	
	public static void cancelCall() throws InterruptedException, IOException, URISyntaxException {
		if (GuestName.equals("")) return;
		
		String urlAjax = "https://" + MainFrame.getUrlAjax();
		HttpClient httpClient = HttpClient.newBuilder().build();
		// form parameters
    Map<Object, Object> data = new HashMap<>();
    data.put("webrtc2_hostId", GuestName);
    data.put("webrtc2_guestId", "cancel");
    data.put("webrtc2_cmd", "cmd1");
    data.put("action", "sign");

    HttpRequest request = HttpRequest.newBuilder()
      .POST(ofFormData(data))
      .uri(URI.create(urlAjax))
      .setHeader("User-Agent",  MainFrame.userAgent)
      .header("Content-Type", "application/x-www-form-urlencoded")
      .build();

    HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());

    GuestName = "";
    
    System.out.println(response.statusCode());
    System.out.println(response.body());
	}
	
	private void onMessage(InboundSseEvent event) {
		System.out.println("Message : " + event.readData());
		String[] partData = event.readData().split(";");
		if (!partData[1].equals("[]")) {
			JSONObject jsonData;
			try {
				jsonData = new JSONObject(partData[1]);
				System.out.println("jsonData: " + jsonData);	
				Boolean sound = false;
				for (int i = 0; i<jsonData.names().length(); i++) {
					String key = jsonData.names().getString(i);
					Object value = jsonData.get(jsonData.names().getString(i));
					//System.out.println("jsonData: " + jsonData);
					if (ServerPolling.UserName.equals(value.toString())) {
						trayMenuToolTip = key + " calls you.";
						GuestName = key;
						sound = true;
					} else {
						trayMenuToolTip = "Video chat";
						GuestName = "";
						sound = false;
					}
				}
			// Sound of call
				AudioInputStream audioIn = null;
				URL fileURL = null;
				if (sound == true && BrowserFrame.isClosed) {
					if (null != ServerPolling.class.getResource("/src/snd/receive_call.wav")) {
						fileURL = ServerPolling.class.getResource("/src/snd/receive_call.wav");
					} else {
						fileURL = ServerPolling.class.getResource("/snd/receive_call.wav");
					}
					try {
						audioIn = AudioSystem.getAudioInputStream(fileURL);
					} catch (UnsupportedAudioFileException e) {
						e.printStackTrace();
					}
					Clip clip = AudioSystem.getClip();
					clip.open(audioIn);
					clip.start();
					long duration=getDurationInSec(audioIn);
					Thread.sleep(duration*1000);
				}
			} catch (JSONException | IOException | LineUnavailableException | InterruptedException e) {
				e.printStackTrace();
			}
		} else {
			trayMenuToolTip = "Video chat";
		}
	}
	
	//Gives duration in seconds for audio files
  public static long getDurationInSec(final AudioInputStream audioIn) {
      final AudioFormat format = audioIn.getFormat();
      double frameRate=format.getFrameRate();
      return (long)(audioIn.getFrameLength()/frameRate);
  }
  
	private void onError(Throwable error) {
		trayMenuToolTip = "Error :" + error.getMessage();
	}

	private void onComplete() {
		if (BrowserFrame.isClosed) {
			try {
				this.startSSE();
				trayMenuToolTip = "Connection restart.";
			} catch (InterruptedException | IOException | URISyntaxException e) {
				e.printStackTrace();
				trayMenuToolTip = "Connection closed.";
			}
		}
	}
	
	public static void appExit() throws IOException, InterruptedException, URISyntaxException {
		String urlAjax = "https://" + MainFrame.getUrlAjax();
		HttpClient httpClient = HttpClient.newBuilder().build();
		// form parameters
    Map<Object, Object> data = new HashMap<>();
    data.put("webrtc2_hostId", ServerPolling.UserName);
    data.put("webrtc2_cmd", "cmd0");
    data.put("action", "sign");

    HttpRequest request = HttpRequest.newBuilder()
      .POST(ofFormData(data))
      .uri(URI.create(urlAjax))
      .setHeader("User-Agent",  MainFrame.userAgent)
      .header("Content-Type", "application/x-www-form-urlencoded")
      .build();

    HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());

    System.out.println(response.statusCode());
    System.out.println(response.body());
	}
	public static HttpRequest.BodyPublisher ofFormData(Map<Object, Object> data) {
    var builder = new StringBuilder();
    for (Map.Entry<Object, Object> entry : data.entrySet()) {
	    if (builder.length() > 0) {
	      builder.append("&");
	    }
	    builder.append(URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8));
	    builder.append("=");
	    builder.append(URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8));
    }
    //System.out.println(builder.toString());
    return HttpRequest.BodyPublishers.ofString(builder.toString());
  }
}
