package App;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.cef.OS;
import org.cef.network.CefCookieManager;

import Browser.MainFrame;

public class MngSetting extends JFrame {
	private static final long serialVersionUID = 1L;

	private static JLabel lblResult = new JLabel("Result: ");
	private static JLabel lblHostName = new JLabel("Host Name: ");
	private static JLabel lblCookiesPath = new JLabel("Cookies Path: ");
	private static JLabel lblDateTime = new JLabel("Date Time: ");
	private static JTextField fldHostName = new JTextField(2);
	private static JTextField fldCookiesPath = new JTextField(2);
	private static JTextField fldDateTime = new JTextField(2);
	private static JButton btnSave = new JButton("Save");
	private static JButton btnSelDir = new JButton("Path");

	private static InputStream fis;
	private static FileOutputStream fos;
	private static BufferedReader br;
	private static BufferedWriter bw;

	public static void main(String[] args) throws URISyntaxException, InterruptedException, IOException {
		JFrame frame = new JFrame();
		frame.setSize(410, 210);
		frame.setResizable(false);
		frame.setVisible(true);
		frame.setLocationRelativeTo(null);
		frame.setTitle("Settings of Video-chat");
			
		BufferedImage imgIcon = null;
		
		if (null != MngSetting.class.getResource("/src/img/settings.png")) {
			imgIcon = ImageIO.read( 
				MngSetting.class.getResource("/src/img/settings.png")
			);
		} else {
			imgIcon = ImageIO.read( 
				MngSetting.class.getResource("/img/settings.png")
			);
		}
		frame.setIconImage(imgIcon);

		try {
			String strSetting = readSettings();
			String[] arrSetting = strSetting.split(";");
			if (arrSetting.length == 3) {
				fldHostName.setText(arrSetting[0]);
				fldCookiesPath.setText(arrSetting[1]);
				fldDateTime.setText(arrSetting[2]);

				// Get user name, cookie expiration
				Thread t0 = new Thread(getCookieManager());
				t0.start();
				Thread.sleep(1000);
		    	
		    Thread t1 = new Thread(new MngCookies());
				t1.start();
				Thread.sleep(1000);
				
				String UserName;
				Thread t2 = new Thread(UserName = MngCookies.getUserNameLoggedIn());
				t2.start();
				
				String cookieExpires;
				Thread t3 = new Thread(cookieExpires = MngCookies.getcookieExpires());
				t3.start();
				
				t0.join();
				t1.join();
				t2.join();
				t3.join();
		        
				UserName = UserName.isEmpty() ? "none" : UserName;
				cookieExpires = cookieExpires.isEmpty() ? "none" : cookieExpires;
		    	
				lblResult.setText("Login: " + UserName + " .Login expire: " + cookieExpires);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}

		btnSave.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				String strURI = fldHostName.getText();
				if (strURI.startsWith("http:")) {
					strURI = strURI.replaceAll("http:", "https:");
				} else if (!strURI.startsWith("https:")) {
					strURI = "https://" + strURI;
				}
				fldHostName.setText(strURI);

				try {
					URI uri = new URI(strURI);
					URLConnection conn = uri.toURL().openConnection();
					conn.connect();
				} catch (IOException | URISyntaxException e1) {
					lblResult.setText("Result: the connection couldn't be established.");
					lblResult.setForeground(Color.RED);
					return;
				}

				SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
				Date date = new Date(System.currentTimeMillis());
				String strDateTime = formatter.format(date);

				try {
					writeSettings(fldHostName.getText(), fldCookiesPath.getText(), strDateTime);
				} catch (IOException e1) {
					e1.printStackTrace();
				}

				fldDateTime.setText(strDateTime);
				lblResult.setText("Result: Data saved successfully.");
				lblResult.setForeground(Color.BLACK);
			}
		});

		btnSelDir.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				JFileChooser directoryChooser = new JFileChooser();
				
				modifyJChooser(directoryChooser.getComponents(), Color.white);
				
				configuringDirectoryChooser(directoryChooser);
				int option = directoryChooser.showOpenDialog(frame);
				if (option == JFileChooser.APPROVE_OPTION) {
					fldCookiesPath.setText(directoryChooser.getSelectedFile().toString());
				} else {
					directoryChooser = null;
				}
			}
		});

		// create a new panel with GridBagLayout manager
		JPanel panel1 = new JPanel(new GridBagLayout());
		JPanel panel2 = new JPanel(new FlowLayout(FlowLayout.CENTER));

		GridBagConstraints constraints = new GridBagConstraints();
		constraints.anchor = GridBagConstraints.WEST;
		constraints.insets = new Insets(10, 10, 10, 10);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		constraints.weightx = 0.5;
		constraints.insets = new Insets(10, 5, 0, 5);

		// add components to the panel
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.gridwidth = 3;
		lblResult.setOpaque(true);
		lblResult.setBackground(Color.decode("#D9D9D9"));
		panel1.add(lblResult, constraints);

		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.gridwidth = 1;
		constraints.weightx = 0.0;
		panel1.add(lblHostName, constraints);

		constraints.gridx = 1;
		constraints.gridwidth = 2;
		panel1.add(fldHostName, constraints);

		constraints.gridx = 0;
		constraints.gridy = 2;
		constraints.gridwidth = 1;
		panel1.add(lblCookiesPath, constraints);

		constraints.gridx = 1;
		constraints.gridwidth = 2;
		panel1.add(fldCookiesPath, constraints);

		constraints.gridx = 0;
		constraints.gridy = 3;
		constraints.gridwidth = 1;
		panel1.add(lblDateTime, constraints);

		constraints.gridx = 1;
		constraints.gridwidth = 2;
		panel1.add(fldDateTime, constraints);

		panel2.add(btnSave);
		panel2.add(btnSelDir);

		frame.getContentPane().add(panel1, BorderLayout.CENTER);
		frame.getContentPane().add(panel2, BorderLayout.SOUTH);
	}

	public static Runnable getCookieManager() throws IOException, URISyntaxException {
		MainFrame frameTmp = new MainFrame(OS.isLinux(), false, false, null);
		CefCookieManager cookieManager = frameTmp.cookieManager;
		frameTmp.dispose();
		
		cookieManager.visitAllCookies(new MngCookies());
		return null;
	}
	
	private static void configuringDirectoryChooser(JFileChooser directoryChooser) {

		directoryChooser.setDialogTitle("Select Cookies Save Directorie");
		directoryChooser.setAcceptAllFileFilterUsed(false);
		directoryChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		directoryChooser.addChoosableFileFilter(null);
		directoryChooser.setCurrentDirectory(new java.io.File("."));
	}

	public static void writeSettings(String fldHostName, String fldCookiesPath, String fldDateTime) throws IOException {

		fos = new FileOutputStream("/settings.txt", false);
		bw = new BufferedWriter(new OutputStreamWriter(fos));

		bw.write(fldHostName.trim());
		bw.newLine();
		bw.write(fldCookiesPath.trim());
		bw.newLine();
		bw.write(fldDateTime);

		bw.close();
	}

	public static String readSettings() throws IOException {
		String strSetting = null;

		try {
			fis = new FileInputStream("/settings.txt");
			br = new BufferedReader(new InputStreamReader(fis, "UTF-8"));

			strSetting = br.readLine(); // HostName
			strSetting = strSetting + ";" + br.readLine(); // CookiesPath
			strSetting = strSetting + ";" + br.readLine(); // DateTime

			br.close();
		} catch (FileNotFoundException e) {
			File newSetting = new File("/settings.txt");
			FileOutputStream outFile = new FileOutputStream(newSetting);
			BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter(outFile));
			bufWriter.write("");
			bufWriter.newLine();
			bufWriter.write("");
			bufWriter.newLine();
			bufWriter.write("");
			bufWriter.close();

			fis = new FileInputStream("/settings.txt");
			br = new BufferedReader(new InputStreamReader(fis, "UTF-8"));

			strSetting = br.readLine(); // HostName
			strSetting = strSetting + ";" + br.readLine(); // CookiesPath
			strSetting = strSetting + ";" + br.readLine(); // DateTime

		}
		return strSetting;
	}
	private static void modifyJChooser(Component[] jc, Color bg) {
    for (int i = 0; i < jc.length; i++) {
      Component c = jc[i];

      // hide file name selection
      if (c.getClass().getSimpleName().equals("MetalFileChooserUI$3")) {
        c.getParent().setVisible(false);
      }
      if (c instanceof JComboBox) {
        Object sel = ((JComboBox<?>) c).getSelectedItem();
        if (sel.toString().contains("AcceptAllFileFilter")) {
        	c.setVisible(false);
        }
      } else if (c instanceof JLabel) {
      	// remove component Files of Type
        String text = ((JLabel) c).getText();
        if (text.equals("Files of Type:") || text.equals("File Name:") || text.equals("Folder Name:")) {
        	c.getParent().getParent().remove(c.getParent());
        }
      }
      if (c instanceof Container) {
      	modifyJChooser(((Container) c).getComponents(), bg);
      }
      c.setBackground(bg);
    }
	}
}
