/*
 * Decompiled with CFR 0.152.
 */
package App;

import App.MngSetting;
import Browser.MainFrame;
import Browser.ServerPolling;
import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;

public class TrayMenu {
    public static TrayIcon trayIcon;

    public static void main(final String[] args) throws AWTException, IOException {
        if (!SystemTray.isSupported()) {
            System.err.println("No system tray available");
            return;
        }
        ActionListener settingListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MngSetting.main(args);
                }
                catch (IOException | InterruptedException | URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        };
        ActionListener videochatListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServerPolling.stopSSE();
                    MainFrame.main(args);
                }
                catch (IOException | InterruptedException | URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        };
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServerPolling.cancelCall();
                }
                catch (IOException | InterruptedException | URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        };
        ActionListener closeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServerPolling.stopSSE();
                    ServerPolling.appExit();
                }
                catch (IOException | InterruptedException | URISyntaxException e1) {
                    e1.printStackTrace();
                }
                System.exit(0);
            }
        };
        ActionListener trayIconListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                trayIcon.setToolTip(ServerPolling.trayMenuToolTip);
            }
        };
        PopupMenu popup = new PopupMenu();
        MenuItem settingItem = new MenuItem("Setting");
        settingItem.addActionListener(settingListener);
        popup.add(settingItem);
        popup.addSeparator();
        MenuItem videochatItem = new MenuItem("Make a call");
        videochatItem.addActionListener(videochatListener);
        popup.add(videochatItem);
        MenuItem cancelItem = new MenuItem("Cancel call");
        cancelItem.addActionListener(cancelListener);
        popup.add(cancelItem);
        popup.addSeparator();
        MenuItem exitItem = new MenuItem("Exit");
        exitItem.addActionListener(closeListener);
        popup.add(exitItem);
        SystemTray tray = SystemTray.getSystemTray();
        BufferedImage imgIcon = null;
        imgIcon = TrayMenu.class.getResource("/src/img/logo.png") != null ? ImageIO.read(TrayMenu.class.getResource("/src/img/logo.png")) : ImageIO.read(TrayMenu.class.getResource("/img/logo.png"));
        TrayIcon trayIcon = new TrayIcon(imgIcon, "Video chat", popup);
        trayIcon.setImageAutoSize(true);
        trayIcon.addActionListener(trayIconListener);
        tray.add(trayIcon);
        ServerPolling serverPolling = new ServerPolling();
        try {
            serverPolling.start();
        }
        catch (IOException | InterruptedException | URISyntaxException e1) {
            e1.printStackTrace();
        }
    }
}

