/*
 * Decompiled with CFR 0.152.
 */
package Browser;

import App.MngSetting;
import Browser.BrowserFrame;
import Browser.ServerPolling;
import Browser.dialog.DownloadDialog;
import Browser.handler.AppHandler;
import Browser.handler.ContextMenuHandler;
import Browser.handler.DragHandler;
import Browser.handler.JSDialogHandler;
import Browser.handler.KeyboardHandler;
import Browser.handler.MessageRouterHandler;
import Browser.handler.MessageRouterHandlerEx;
import Browser.handler.RequestHandler;
import Browser.ui.ControlPanel;
import Browser.ui.MenuBar;
import Browser.ui.StatusPanel;
import Browser.util.DataUri;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefCommandLine;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.network.CefCookieManager;

public class MainFrame
extends BrowserFrame {
    private static final long serialVersionUID = 1L;
    public CefCookieManager cookieManager = null;
    public static CefApp.CefVersion version;
    public static String userAgent;
    private final CefClient client_;
    private String errorMsg_ = "";
    private ControlPanel control_pane_;
    private StatusPanel status_panel_;
    private boolean browserFocus_ = true;
    private boolean osr_enabled_;
    private boolean transparent_painting_enabled_;

    public static void main(String[] args) throws IOException, URISyntaxException {
        if (!CefApp.startup((String[])args)) {
            System.out.println("Startup CefApp initialization failed!");
            return;
        }
        System.out.println("Startup CefApp initialization success!");
        boolean osrEnabledArg = false;
        boolean transparentPaintingEnabledArg = false;
        boolean createImmediately = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if ((arg = arg.toLowerCase()).equals("--off-screen-rendering-enabled")) {
                osrEnabledArg = true;
            } else if (arg.equals("--transparent-painting-enabled")) {
                transparentPaintingEnabledArg = true;
            } else if (arg.equals("--create-immediately")) {
                createImmediately = true;
            }
            ++n2;
        }
        System.out.println("Offscreen rendering " + (osrEnabledArg ? "enabled" : "disabled"));
        MainFrame frame = new MainFrame(osrEnabledArg, transparentPaintingEnabledArg, createImmediately, args);
        frame.setSize(718, 700);
        frame.setResizable(false);
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
    }

    public MainFrame(boolean osrEnabled, boolean transparentPaintingEnabled, boolean createImmediately, String[] args) throws IOException, URISyntaxException {
        String strURL;
        CefApp myApp;
        this.osr_enabled_ = osrEnabled;
        this.transparent_painting_enabled_ = transparentPaintingEnabled;
        String verOS = " (" + System.getProperty("os.name") + "; " + System.getProperty("os.arch") + ")";
        String verJava = " Java/" + System.getProperty("java.runtime.version");
        userAgent = "WP-WebRTC2-client" + verOS + verJava;
        if (CefApp.getState() != CefApp.CefAppState.INITIALIZED) {
            CefSettings settings = new CefSettings();
            settings.user_agent = userAgent;
            settings.windowless_rendering_enabled = osrEnabled;
            settings.cache_path = this.getCookiesPath();
            CefSettings cefSettings = settings;
            cefSettings.getClass();
            settings.background_color = new CefSettings.ColorType(cefSettings, 100, 255, 242, 211);
            myApp = CefApp.getInstance((String[])args, (CefSettings)settings);
            version = myApp.getVersion();
            System.out.println("Using:\n" + version);
            CefApp.addAppHandler((CefAppHandler)new AppHandler(args){

                public void onBeforeCommandLineProcessing(String process_type, CefCommandLine command_line) {
                    super.onBeforeCommandLineProcessing(process_type, command_line);
                    if (process_type.isEmpty()) {
                        command_line.appendSwitchWithValue("enable-media-stream", "true");
                        command_line.appendSwitchWithValue("use-fake-ui-for-media-stream", "true");
                        command_line.appendSwitchWithValue("persist-session-cookies", "true");
                    }
                }
            });
        } else {
            myApp = CefApp.getInstance();
        }
        this.client_ = myApp.createClient();
        BufferedImage imgIcon = null;
        imgIcon = MainFrame.class.getResource("/src/img/videochat.png") != null ? ImageIO.read(MainFrame.class.getResource("/src/img/videochat.png")) : ImageIO.read(MainFrame.class.getResource("/img/videochat.png"));
        this.setIconImage(imgIcon);
        DownloadDialog downloadDialog = new DownloadDialog(this);
        this.client_.addContextMenuHandler((CefContextMenuHandler)new ContextMenuHandler(this));
        this.client_.addDownloadHandler((CefDownloadHandler)downloadDialog);
        this.client_.addDragHandler((CefDragHandler)new DragHandler());
        this.client_.addJSDialogHandler((CefJSDialogHandler)new JSDialogHandler());
        this.client_.addKeyboardHandler((CefKeyboardHandler)new KeyboardHandler());
        this.client_.addRequestHandler((CefRequestHandler)new RequestHandler(this));
        CefMessageRouter msgRouter = CefMessageRouter.create();
        msgRouter.addHandler((CefMessageRouterHandler)new MessageRouterHandler(), true);
        msgRouter.addHandler((CefMessageRouterHandler)new MessageRouterHandlerEx(this.client_), false);
        this.client_.addMessageRouter(msgRouter);
        this.client_.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                MainFrame.this.control_pane_.setAddress(browser, url);
            }

            public void onTitleChange(CefBrowser browser, String title) {
                MainFrame.this.setTitle(title);
            }

            public void onStatusMessage(CefBrowser browser, String value) {
                MainFrame.this.status_panel_.setStatusText(value);
            }
        });
        this.client_.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                MainFrame.this.control_pane_.update(browser, isLoading, canGoBack, canGoForward);
                MainFrame.this.status_panel_.setIsInProgress(isLoading);
                if (!isLoading && !MainFrame.this.errorMsg_.isEmpty()) {
                    browser.loadURL(DataUri.create("text/html", MainFrame.this.errorMsg_));
                    MainFrame.this.errorMsg_ = "";
                }
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                if (errorCode != CefLoadHandler.ErrorCode.ERR_NONE && errorCode != CefLoadHandler.ErrorCode.ERR_ABORTED) {
                    MainFrame.this.errorMsg_ = "<html><head>";
                    MainFrame.this.errorMsg_ = String.valueOf(MainFrame.this.errorMsg_) + "<title>Error while loading</title>";
                    MainFrame.this.errorMsg_ = String.valueOf(MainFrame.this.errorMsg_) + "</head><body>";
                    MainFrame.this.errorMsg_ = String.valueOf(MainFrame.this.errorMsg_) + "<h1>" + errorCode + "</h1>";
                    MainFrame.this.errorMsg_ = String.valueOf(MainFrame.this.errorMsg_) + "<h3>Failed to load " + failedUrl + "</h3>";
                    MainFrame.this.errorMsg_ = String.valueOf(MainFrame.this.errorMsg_) + "<p>" + (errorText == null ? "" : errorText) + "</p>";
                    MainFrame.this.errorMsg_ = String.valueOf(MainFrame.this.errorMsg_) + "</body></html>";
                    browser.stopLoad();
                }
            }
        });
        String string = strURL = ServerPolling.UserName.isEmpty() ? this.getUrlProfile() : this.getUrlVideoChat();
        if (args == null) {
            strURL = "http://www.google.com";
        }
        CefBrowser browser = this.client_.createBrowser(strURL, osrEnabled, transparentPaintingEnabled, null);
        this.setBrowser(browser);
        JPanel contentPanel = this.createContentPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        this.control_pane_.getAddressField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = false;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                MainFrame.this.control_pane_.getAddressField().requestFocus();
            }
        });
        this.client_.addFocusHandler((CefFocusHandler)new CefFocusHandlerAdapter(){

            public void onGotFocus(CefBrowser browser) {
                if (MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = true;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                browser.setFocus(true);
            }

            public void onTakeFocus(CefBrowser browser, boolean next) {
                MainFrame.this.browserFocus_ = false;
            }
        });
        if (createImmediately) {
            browser.createImmediately();
        }
        contentPanel.add(this.getBrowser().getUIComponent(), "Center");
        this.cookieManager = CefCookieManager.getGlobalManager();
        MenuBar menuBar = new MenuBar(this, browser, this.control_pane_, downloadDialog, this.cookieManager);
        menuBar.addBookmark("Video Chat", this.getUrlVideoChat());
        menuBar.addBookmark("Profile", this.getUrlProfile());
        menuBar.addBookmarkSeparator();
        menuBar.addBookmark("support JCEF", "https://bitbucket.org/chromiumembedded/java-cef");
        menuBar.addBookmark("support CEF", "https://bitbucket.org/chromiumembedded/cef");
        menuBar.addBookmarkSeparator();
        menuBar.addBookmark("support WebRTC2 client", "https://adminkov.bcr.by/support");
        menuBar.addBookmark("support WebRTC2", "https://wordpress.org/plugins/wp-webrtc2");
        this.setJMenuBar(menuBar);
    }

    private JPanel createContentPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.control_pane_ = new ControlPanel(this.getBrowser());
        this.status_panel_ = new StatusPanel();
        contentPanel.add((Component)this.control_pane_, "North");
        contentPanel.add((Component)this.status_panel_, "South");
        return contentPanel;
    }

    public boolean isOsrEnabled() {
        return this.osr_enabled_;
    }

    public boolean isTransparentPaintingEnabled() {
        return this.transparent_painting_enabled_;
    }

    public String getUrlVideoChat() throws IOException {
        String hostUrlVideoChat = "";
        String strSetting = MngSetting.readSettings();
        String[] arrSetting = strSetting.split(";");
        if (arrSetting.length == 3) {
            hostUrlVideoChat = arrSetting[0];
        } else {
            JOptionPane.showMessageDialog(null, "See item menu - Setting", "Url of VideoChat - is invalid.", 2);
        }
        return hostUrlVideoChat;
    }

    private String getUrlProfile() throws IOException, URISyntaxException {
        String hostUrlProfile = "";
        String strSetting = MngSetting.readSettings();
        String[] arrSetting = strSetting.split(";");
        if (arrSetting.length == 3) {
            hostUrlProfile = arrSetting[0];
            if (!hostUrlProfile.isEmpty()) {
                URI resultURI = new URI(hostUrlProfile);
                String strDomain = resultURI.getHost();
                hostUrlProfile = String.valueOf(strDomain) + "/wp-admin/profile.php";
            }
        } else {
            JOptionPane.showMessageDialog(null, "See item menu - Setting", "Url of Profile - is invalid.", 2);
        }
        return hostUrlProfile;
    }

    public static String getUrlAjax() throws IOException, URISyntaxException {
        String hostUrlAjax = "";
        String strSetting = MngSetting.readSettings();
        String[] arrSetting = strSetting.split(";");
        if (arrSetting.length == 3) {
            hostUrlAjax = arrSetting[0];
            if (!hostUrlAjax.isEmpty()) {
                URI resultURI = new URI(hostUrlAjax);
                String strDomain = resultURI.getHost();
                hostUrlAjax = String.valueOf(strDomain) + "/wp-admin/admin-ajax.php";
            }
        } else {
            JOptionPane.showMessageDialog(null, "See item menu - Setting", "Url of admin-ajax.php - is invalid.", 2);
        }
        return hostUrlAjax;
    }

    public String getCookiesPath() throws IOException {
        String cookiesPath = "";
        try {
            FileInputStream fis = new FileInputStream("/settings.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            cookiesPath = br.readLine();
            cookiesPath = br.readLine();
            br.close();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Cookies Path - is invalid", 2);
        }
        return cookiesPath;
    }
}

