/*
 * Decompiled with CFR 0.152.
 */
package Browser.handler;

import java.nio.ByteBuffer;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class ResourceHandler
extends CefResourceHandlerAdapter {
    private int startPos = 0;
    private static final String html = new String("<html>\n  <head>\n    <title>ResourceHandler Test</title>\n  </head>\n  <body>\n    <h1>ResourceHandler Test</h1>\n    <p>You have entered the URL: http://www.foo.bar. This page is generated by the application itself and<br/>\n       no HTTP request was sent to the internet.\n    <p>See class <u>tests.handler.ResourceHandler</u> and the <u>RequestHandler</u> implementation for details.</p>\n  </body>\n</html>");

    public boolean processRequest(CefRequest request, CefCallback callback) {
        System.out.println("processRequest: " + request);
        this.startPos = 0;
        callback.Continue();
        return true;
    }

    public void getResponseHeaders(CefResponse response, IntRef response_length, StringRef redirectUrl) {
        System.out.println("getResponseHeaders: " + response);
        response_length.set(html.length());
        response.setMimeType("text/html");
        response.setStatus(200);
    }

    public boolean readResponse(byte[] data_out, int bytes_to_read, IntRef bytes_read, CefCallback callback) {
        int length = html.length();
        if (this.startPos >= length) {
            return false;
        }
        int endPos = this.startPos + bytes_to_read;
        String dataToSend = endPos > length ? html.substring(this.startPos) : html.substring(this.startPos, endPos);
        ByteBuffer result = ByteBuffer.wrap(data_out);
        result.put(dataToSend.getBytes());
        bytes_read.set(dataToSend.length());
        this.startPos = endPos;
        return true;
    }

    public void cancel() {
        System.out.println("cancel");
        this.startPos = 0;
    }
}

