/*
 * Decompiled with CFR 0.152.
 */
package Browser.ui;

import Browser.MainFrame;
import Browser.dialog.CookieManagerDialog;
import Browser.dialog.DevToolsDialog;
import Browser.dialog.DownloadDialog;
import Browser.dialog.UrlRequestDialog;
import Browser.dialog.WebPluginManagerDialog;
import Browser.ui.ControlPanel;
import Browser.util.DataUri;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.network.CefCookieManager;

public class MenuBar
extends JMenuBar {
    private final MainFrame owner_;
    private final CefBrowser browser_;
    private String last_selected_file_ = "";
    private final JMenu bookmarkMenu_;
    private final ControlPanel control_pane_;
    private final DownloadDialog downloadDialog_;
    private final CefCookieManager cookieManager_;

    public MenuBar(MainFrame owner, CefBrowser browser, ControlPanel control_pane, DownloadDialog downloadDialog, CefCookieManager cookieManager) {
        this.owner_ = owner;
        this.browser_ = browser;
        this.control_pane_ = control_pane;
        this.downloadDialog_ = downloadDialog;
        this.cookieManager_ = cookieManager;
        this.setEnabled(this.browser_ != null);
        JMenu fileMenu = new JMenu("File");
        JMenuItem openFileItem = new JMenuItem("Open file...");
        openFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser(new File(MenuBar.this.last_selected_file_));
                fc.showOpenDialog(MenuBar.this.owner_);
                File selectedFile = fc.getSelectedFile();
                if (selectedFile != null) {
                    MenuBar.this.last_selected_file_ = selectedFile.getAbsolutePath();
                    MenuBar.this.browser_.loadURL("file:///" + selectedFile.getAbsolutePath());
                }
            }
        });
        fileMenu.add(openFileItem);
        JMenuItem openFileDialog = new JMenuItem("Save as...");
        openFileDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CefRunFileDialogCallback callback = new CefRunFileDialogCallback(){

                    public void onFileDialogDismissed(int selectedAcceptFilter, Vector<String> filePaths) {
                        if (!filePaths.isEmpty()) {
                            try {
                                SaveAs saveContent = new SaveAs(filePaths.get(0));
                                (this).MenuBar.this.browser_.getSource((CefStringVisitor)saveContent);
                            }
                            catch (FileNotFoundException | UnsupportedEncodingException e) {
                                (this).MenuBar.this.browser_.executeJavaScript("alert(\"Can't save file\");", (this).MenuBar.this.control_pane_.getAddress(), 0);
                            }
                        }
                    }
                };
                MenuBar.this.browser_.runFileDialog(CefDialogHandler.FileDialogMode.FILE_DIALOG_SAVE, MenuBar.this.owner_.getTitle(), "index.html", null, 0, callback);
            }
        });
        fileMenu.add(openFileDialog);
        JMenuItem printItem = new JMenuItem("Print...");
        printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.print();
            }
        });
        fileMenu.add(printItem);
        fileMenu.addSeparator();
        JMenuItem viewSource = new JMenuItem("View source");
        viewSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.viewSource();
            }
        });
        fileMenu.add(viewSource);
        fileMenu.addSeparator();
        JMenuItem showDownloads = new JMenuItem("Show Downloads");
        showDownloads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.downloadDialog_.setVisible(true);
                MenuBar.this.downloadDialog_.setSize(740, 695);
            }
        });
        fileMenu.add(showDownloads);
        JMenuItem showCookies = new JMenuItem("Show Cookies");
        showCookies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CookieManagerDialog cookieManager = new CookieManagerDialog((Frame)MenuBar.this.owner_, "Cookie Manager", MenuBar.this.cookieManager_);
                cookieManager.setVisible(true);
                cookieManager.setSize(740, 695);
            }
        });
        fileMenu.add(showCookies);
        JMenuItem showPlugins = new JMenuItem("Show Plugins");
        showPlugins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPluginManagerDialog pluginManager = new WebPluginManagerDialog((Frame)MenuBar.this.owner_, "Plugin Manager");
                pluginManager.setVisible(true);
                pluginManager.setSize(740, 695);
            }
        });
        fileMenu.add(showPlugins);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.owner_.dispatchEvent(new WindowEvent(MenuBar.this.owner_, 201));
            }
        });
        fileMenu.add(exitItem);
        this.bookmarkMenu_ = new JMenu("Bookmarks");
        JMenuItem addBookmarkItem = new JMenuItem("Add bookmark");
        addBookmarkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.addBookmark(MenuBar.this.owner_.getTitle(), MenuBar.this.control_pane_.getAddress());
            }
        });
        this.bookmarkMenu_.add(addBookmarkItem);
        this.bookmarkMenu_.addSeparator();
        JMenu serviceMenu = new JMenu("Service");
        JMenuItem showInfo = new JMenuItem("Show Info");
        String verOS = " (" + System.getProperty("os.name") + "; " + System.getProperty("os.arch") + ")";
        String verJava = " Java/" + System.getProperty("java.runtime.version");
        final String userAgent = "WP-WebRTC2-client" + verOS + verJava;
        showInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String info = "<html><head><title>Browser info</title></head>";
                info = String.valueOf(info) + "<body><h1>Browser info</h1><table border=\"0\">";
                info = String.valueOf(info) + "<tr><td>OS:</td><td>" + System.getProperty("os.name") + "; ver." + System.getProperty("os.version") + "; " + System.getProperty("os.arch") + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>Java version:</td><td>" + System.getProperty("java.runtime.version") + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>Install dir JRE:</td><td>" + System.getProperty("java.home") + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>JRE vendor:</td><td>" + System.getProperty("java.vendor") + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>JRE URL:</td><td>" + System.getProperty("java.vendor.url") + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>JRE version:</td><td>" + System.getProperty("java.version") + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>User Agent:</td><td>" + userAgent + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>CanGoBack</td><td>" + MenuBar.this.browser_.canGoBack() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>CanGoForward</td><td>" + MenuBar.this.browser_.canGoForward() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>Url last visit</td><td>" + MenuBar.this.browser_.getURL() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>Zoom-Level</td><td>" + MenuBar.this.browser_.getZoomLevel() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>Using:</td><td>" + MainFrame.version + "</td></tr>";
                info = String.valueOf(info) + "</table></body></html>";
                MenuBar.this.browser_.loadURL(DataUri.create("text/html", info));
            }
        });
        serviceMenu.add(showInfo);
        final JMenuItem showDevTools = new JMenuItem("Show DevTools");
        showDevTools.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevToolsDialog devToolsDlg = new DevToolsDialog((Frame)MenuBar.this.owner_, "DEV Tools", MenuBar.this.browser_);
                devToolsDlg.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        showDevTools.setEnabled(true);
                    }
                });
                devToolsDlg.setVisible(true);
                devToolsDlg.setSize(740, 695);
                showDevTools.setEnabled(false);
            }
        });
        serviceMenu.add(showDevTools);
        JMenuItem testURLRequest = new JMenuItem("Show URL Request");
        testURLRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UrlRequestDialog dlg = new UrlRequestDialog((Frame)MenuBar.this.owner_, "URL Request Test");
                dlg.setVisible(true);
                dlg.setSize(740, 695);
            }
        });
        serviceMenu.add(testURLRequest);
        JMenuItem newWindow = new JMenuItem("New window");
        newWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainFrame frame = new MainFrame(OS.isLinux(), false, false, null);
                    frame.setSize(740, 695);
                    frame.setVisible(true);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        });
        serviceMenu.addSeparator();
        serviceMenu.add(newWindow);
        this.add(fileMenu);
        this.add(this.bookmarkMenu_);
        this.add(serviceMenu);
    }

    public void addBookmark(String name, String URL2) {
        Component[] entries;
        if (this.bookmarkMenu_ == null) {
            return;
        }
        Component[] componentArray = entries = this.bookmarkMenu_.getMenuComponents();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem item;
            Component itemEntry = componentArray[n2];
            if (itemEntry instanceof JMenuItem && (item = (JMenuItem)itemEntry).getText().equals(name)) {
                item.setActionCommand(URL2);
                return;
            }
            ++n2;
        }
        JMenuItem menuItem = new JMenuItem(name);
        menuItem.setActionCommand(URL2);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.loadURL(e.getActionCommand());
            }
        });
        this.bookmarkMenu_.add(menuItem);
        this.validate();
    }

    public void addBookmarkSeparator() {
        this.bookmarkMenu_.addSeparator();
    }

    class SaveAs
    implements CefStringVisitor {
        private PrintWriter fileWriter_;

        public SaveAs(String fName) throws FileNotFoundException, UnsupportedEncodingException {
            this.fileWriter_ = new PrintWriter(fName, "UTF-8");
        }

        public void visit(String string) {
            this.fileWriter_.write(string);
            this.fileWriter_.close();
        }
    }
}

